
/**
 ******************************************************************************
 *
 * @file        MG32x02z_USBD_Descriptor.h
 * @brief       This file contains all the functions prototypes for the USB description 
 *              firmware library.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.00
 * @date        2020/06/05
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _USB_DSC_H
#define _USB_DSC_H

/* Includes ------------------------------------------------------------------*/
#include "MG32x02z.h"
#include "MG32x02z_USB_Init.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define FKB_TOTALFUNCTION    0x14

#define    HID_REPORT_LENGTH sizeof(HID_REPORT)

#define    USB_VID          0x0E6A
#define    USB_PID          0x0320
#define    USB_DID          0x0100

#define    HID_MAX          128

#define    MF_STRING                             // Supported Manufacture String
#define    PD_STRING                             // Supported Product String
//#define    SN_STRING                             // Supported SerialNumber String

#define    EP0_PACKET_SIZE       MG_USB_EP0_DSIZE

#define    HID0_HID_REPORT_LENGTH sizeof(USB_INTERFACE0_HID_REPORT)   /*!< USB HID0 Descriptor data size.*/
#define    HID1_HID_REPORT_LENGTH sizeof(USB_INTERFACE1_HID_REPORT)   /*!< USB HID1 Descriptor data size.*/

#define USB_CONFIGURATION_DESC_SIZE        9                          /*!< USB Configuration descriptor data size. */
#define USB_INTERFACE_DESC_SIZE            9                          /*!< USB Interface descriptor data size. */
#define USB_HID_DESC_SIZE                  9                          /*!< USB HID descriptor data size. */
#define USB_ENDPOINT_DESC_SIZE             7                          /*!< USB Endpoint descriptor data size. */

#define USB_CONFIGURATION_TOTAOL_INTERFACE   5    // Total interface 
#define USB_CONFIGURATION_DESC_TOTAOSIZE   253

#define HID_REPORT_SIZE  sizeof(USB_HID_REPORT)
#define HID_REPORT2_SIZE (sizeof(USB_HID_REPORT2))

#define MFS_LEN sizeof("Megawin Technology Inc.")*2

#define PDS_LEN sizeof("Sample Audio")*2

#define SNS_LEN sizeof("123456")*2

#define HID_REPORT_LEN sizeof(USB_HID_REPORT)

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
extern const uint8_t USB_DEVICE_DESCRIPTOR[];
extern const uint8_t USB_CONGFIGURATION_DESCRIPTOR[];
extern const uint8_t USB_INTERFACE0_DESCRIPTOR[];
extern const uint8_t USB_INTERFACE0_IN_ENDPOINT_DESCRIPTOR[];
extern const uint8_t USB_INTERFACE1_DESCRIPTOR[];
extern const uint8_t USB_INTERFACE1_IN_ENDPOINT_DESCRIPTOR[];
extern const uint8_t USB_STRING_DESCRIPTOR[]; 

extern const uint8_t USB_HID_REPORT[];
extern const uint8_t USB_HID_REPORT2[];

extern const uint8_t MANUFACTURER_DESCRIPTOR[];

extern const uint8_t PRODUCT_DESCRIPTOR[];

extern const uint8_t SERIALNUMBER_DESCRIPTOR[];

extern const uint8_t USB_HID_REPORT[];


#endif
















